#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: setup.py 9702 2016-08-08 04:36:50Z Eric $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Eric $ (last)
# $Date: 2016-08-08 12:36:50 +0800 (Mon, 08 Aug 2016) $
# $Revision: 9702 $

import os

try:
    from Iuppiter.DistUtil import setup
except ImportError:
    os.system('pip install Iuppiter --no-cache-dir')
    from Iuppiter.DistUtil import setup
    
extraRequirements = []

from sys import platform as _platform

# Python for Window Extensions (pypiwin32) is only for Windows.
if _platform == "win32":
    # win32 (https://pypi.python.org/pypi/pypiwin32/219)
    extraRequirements.append('pip install pypiwin32')    

setup(
    'Iuno',
    description="Support package for all Nuwa Information's server projects.",
    version='%s.%s' % ('2.1.7', "$Revision: 9702 $"[11:-2]),
    license='Proprietary License',
    author='Bear',
    author_email='bear@nuwainfo.com',
    url='http://www.nuwainfo.com/',
)
