#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 9992 2017-05-28 14:30:29Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-05-28 22:30:29 +0800 (週日, 28 五月 2017) $
# $Revision: 9992 $

from django.db import models
from django.utils import timezone

class AdminPlaceholder(models.Model):
    name = models.CharField(max_length=20, editable=False, null=True)
    
    page = models.ForeignKey(
        'cms.Page',
        on_delete=models.CASCADE,
        editable=False,
        default=None,
        null=True,
    )
    text = models.TextField()
    useGlobalAdminPlaceholder = models.BooleanField(default=False)
        
    def __unicode__(self):
        return u"AdminPlaceholder: %d" % (self.id,)
        
        
class BlockDisplayControl(models.Model):
    name = models.CharField(max_length=20, editable=False, null=True)
    
    page = models.ForeignKey(
        'cms.Page',
        on_delete=models.CASCADE,
        editable=False,
        default=None,
        null=True
    )
    display = models.BooleanField(default=True)
    useGlobalBlockDisplayControl = models.BooleanField(default=False)
        
    def __unicode__(self):
        return u"BlockDisplayControl: %d" % (self.id,)
