#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 12638 2020-12-17 07:19:51Z Lavender $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2020-12-17 16:19:51 +0900 (週四, 17 十二月 2020) $
# $Revision: 12638 $

import random
import requests
import collections
import json

import requests

from django.template import Context, Template
from django.conf import settings
from six.moves import urllib_parse, urllib_request, urllib_error

from Iuno import require
from Iuppiter.Encoding import utf8
from Iuppiter.DjangoUtil import extendInstalledApps, patterns

def attachSettings(settingsLocals, backends, preferred, config):
    if "IUNO_CLOUD_SMS_ADMIN" in settingsLocals:
        extendInstalledApps(settingsLocals, (
            'Iuno.cloud.sms',
        ))
    else:
        require("IUNO_CLOUD_SMS_CLIENT_TOKEN", settingsLocals) 
        
DEFAULT_PREFIX_COUNT = 4
DEFAULT_CODE_COUNT = 6
DEFAULT_TEMPLATE = ("{%if site %}[{{ site }}]{% endif %} "
    "您好，驗證碼為6位數字: {{ code }}，請確認網頁識別碼 {{ prefix }}")

DEFAUTL_API_URL = "https://api.nuwainfo.com/sms/api/send/"

def verify(phone, template=None, prefixCount=DEFAULT_PREFIX_COUNT, codeCount=DEFAULT_CODE_COUNT):
    prefix = "".join([random.choice('ABCDEFGHIJKLMNOPQRSTUVWXYZ') for i in range(prefixCount)])
    code = "".join([random.choice('0123456789') for i in range(codeCount)])
    
    # 在 __init__.py 內不能先 import model，因此在這裡 import 
    from django.contrib.sites.models import Site
    
    if template:
        message = Template(template)
    else:
        message = Template(DEFAULT_TEMPLATE)
    message = message.render(Context({
        "prefix": prefix,
        "code": code,
        "site": Site.objects.get_current().name,
    }))
    
    payload = {
        "phone": phone,
        "message": message,
        "token": settings.IUNO_CLOUD_SMS_CLIENT_TOKEN,
    }
    if hasattr(settings, "IUNO_CLOUD_SMS_CLIENT_URL"):
        url = settings.IUNO_CLOUD_SMS_CLIENT_URL
    else:
        url = DEFAUTL_API_URL
        
    response = requests.post(url, payload) 
    data = json.loads(response.text)
        
    if data.get("stats"):
        data.update({
            "prefix": prefix,
            "code": code,
        })
    data.update({
        "prefix": prefix,
        "code": code,
    })
    
    return data
    
def attachURLs(settings, urlpatterns):
    from django.conf.urls import url
    from Iuno.cloud.sms.views import callAPISMS, sendSMSAuthentication
    
    addCloudSMSAPIUrl = False
    if hasattr(settings ,'IUNO_CLOUD_SMS_ADMIN'):
        if settings.IUNO_CLOUD_SMS_ADMIN:
            if hasattr(settings ,'IUNO_CLOUD_SMS_ADMIN'):
                services = settings.IUNO_CLOUD_SERVICES
                if 'sms' in services:
                    addCloudSMSAPIUrl = True
            else:
                addCloudSMSAPIUrl = True
                
    if addCloudSMSAPIUrl:
        urlpatterns += patterns('',
            url(r'^sms/api/send/', callAPISMS, name='callAPISMS'),
        )
        
    if hasattr(settings ,  'IUNO_CLOUD_SMS_MEDIATOR'):
        urlpatterns += patterns('',
            url(r'^sms/authentication/send/', 
                sendSMSAuthentication, name='sendSMSAuthentication'),
        )
    

class SMS(object):

    def __init__(self, phones, message, username='', password='',
                 date=None, hour=None, min=None, **kws):
        """         
        Constructor.
        
        @param phones List of the phone numbers that you want to send.
        @param message Message.
        @param username Your username.
        @param password Your password.
        @param date Send date if method is 'reserved'. Format: YYYY/MM/DD
        @param hour Send hour if method is 'reserved'. Format: 00~23
        @param min Send date if min is 'reserved'. Format: 00~59
        """
        if isinstance(phones, str):
            self.phoneLists = [str(phones)]
        else:
            self.phoneLists = phones
            
        if isinstance(phones, collections.Iterable):
            #http://stackoverflow.com/questions/1952464/
            #in-python-how-do-i-determine-if-an-object-is-iterable
            self.phoneLists = [
                self.phoneLists[x: x + 250] for x in range(0, len(phones), 250)
            ]
            self.phoneLists = [','.join(l) for l in self.phoneLists]
            
        else:
            raise ValueError("phones must be iterable or a string")
        
        if date != None or hour != None or min != None:
            self.postData = [
                ('username', username if username else 'nuwa'),
                ('password', password if password else 'nuwa25025529'),
                ('method', "2"),
                ('sms_msg', message),
                ('send_date', date),
                ('hour', hour),
                ('min', min),
            ]
        else:
            self.postData = [
                ('username', username if username else 'nuwa'),
                ('password', password if password else 'nuwa25025529'),
                ('method', "1"),
                ('sms_msg', message)
            ]

        self.result = None
        self.resultDetails = []
    
    def sendMessage(self):
        """
        Send SMS message.
        
        return Sms sent result string. Format: {"stats":true,
                                                "error_code":"000",
                                                "error_msg":"1646437|1|2"}
        """
        for phones in self.phoneLists:

            phoneData = ('phone', str(phones))
            postData = self.postData
            postData.append(phoneData)
            url = 'http://sms-get.com/api_send.php?' + urllib_parse.urlencode(postData)
            
            try:
                result = requests.get(url)
                result = json.loads(result.text)
            except Exception as e:
                result = {
                    "stats": False,
                    "error_code": -999,
                    "error_msg": str(e),
                }
             
            self.resultDetails.append(result)

        self.setResult()
        
        return self.result
        
    
    def getSendingDetails(self):
        '''
        Get sending message detailed results.
        
        
        @return Result details.
        '''
        
        return self.resultDetails
        
    def setResult(self):
        '''
        Set sending message result.
        '''
        result = True
        for r in self.resultDetails:
            if r['error_code'] != '000':
                result = False
                break
        
        self.result = result
        

