#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: BoilerplateTags.py 11069 2018-05-21 10:18:52Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-05-21 18:18:52 +0800 (週一, 21 五月 2018) $
# $Revision: 11069 $

from django import template
from cms.templatetags.cms_tags import PlaceholderOptions
from classytags.arguments import Argument, MultiValueArgument
from classytags.core import Tag, Options

from Zephyrus.boilerplate.models import AdminPlaceholder, BlockDisplayControl

register = template.Library()

class AdminPlaceholderTag(Tag):
    name = 'adminPlaceholder'
    
    options = PlaceholderOptions(
        Argument('name', resolve=False),
        MultiValueArgument('extra_bits', required=False, resolve=False),
        blocks=[
            ('endAdminPlaceholder', 'nodelist'),
        ],
    )
    
    def render_tag(self, context, name, extra_bits, nodelist=None):
        page = context.get('current_page', None)
        if page:
            page = context.get('page_obj', None)
        fromUrl = context['request'].path_info
        
        globalObj, created = AdminPlaceholder.objects.get_or_create(
                name=name,
                fromUrl=None,
                defaults={'text': '', 'page': None,},
            )
            
        if nodelist:
            text = nodelist.render(context)
        else:
            text = ''
            
        obj, created = AdminPlaceholder.objects.get_or_create(
            name=name,
            fromUrl=fromUrl,
            defaults={'text': text, 'page': page,},
        )
        
        if obj.useGlobalAdminPlaceholder:
            obj = globalObj
        
        return obj.text
        
class BlockDisplayControlTag(Tag):
    name = 'blockDisplayControlTag'

    options = Options(
        Argument('name'),
        blocks=[('endBlockDisplayControl', 'nodelist')],
    )

    def render_tag(self, context, name, nodelist):
        page = context.get('current_page', None)
        if page:
            page = context.get('page_obj', None)
        fromUrl = context['request'].path_info
        
        globalObj, created = BlockDisplayControl.objects.get_or_create(
                name=name,
                fromUrl=None,
                defaults={'page': None,},
            )
        
        obj, created = BlockDisplayControl.objects.get_or_create(
            name=name,
            fromUrl=fromUrl,
            defaults={'page': page,},
        )
        
        if obj.useGlobalBlockDisplayControl:
            obj = globalObj
        
        if obj.display:
            text = nodelist.render(context)
        else:
            text = ''
        
        return text

register.tag('blockDisplayControl', BlockDisplayControlTag) 
register.tag('adminPlaceholder', AdminPlaceholderTag)
