#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: urls.py 12270 2020-05-26 04:48:53Z Trista $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Trista $
# $Date: 2020-05-26 12:48:53 +0800 (Tue, 26 May 2020) $
# $Revision: 12270 $

from django.conf.urls import url

from Zephyrus.blog_extension import views


urlpatterns = [
    url(
        r'^call-to-action/email$', 
        views.CallToActionEmailView.as_view(), 
        name='call_to_action_email'
    ),
    url(r'^call-to-action/social$', views.CallToActionSocialView.as_view(), 
        name='call_to_action_social'),
    url(r'^call-to-action/file$', views.showTargetFile, name='showTargetFile'),
    url(r'^call-to-action/article/(?P<articleId>\w+)', views.renderArticle, name='renderArticle'),
]