#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: AttachSettingsTest.py 9742 2017-02-08 01:01:19Z David $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $ (last)
# $Date: 2017-02-08 09:01:19 +0800 (Wed, 08 Feb 2017) $
# $Revision: 9742 $
import Iuno
from django.test import TestCase

class TestAttachSettings(TestCase):
    
    def runTest(self):
        
        settingsContent = {
            'INSTALLED_APPS': (
                'django.contrib.admin',
                'django.contrib.auth',
                'django.contrib.contenttypes',
                'django.contrib.sessions',
                'django.contrib.messages',
                'django.contrib.staticfiles',
            ),

            "MIDDLEWARE_CLASSES": (
                'django.contrib.sessions.middleware.SessionMiddleware',
                'django.middleware.common.CommonMiddleware',
                'django.middleware.csrf.CsrfViewMiddleware',
                'django.contrib.auth.middleware.AuthenticationMiddleware',
                'django.contrib.auth.middleware.SessionAuthenticationMiddleware',
                'django.contrib.messages.middleware.MessageMiddleware',
                'django.middleware.clickjacking.XFrameOptionsMiddleware',
                'django.middleware.security.SecurityMiddleware',
            ),

            "ROOT_URLCONF": 'TemplatesShop.urls',

            "TEMPLATES": [
                {
                    'BACKEND': 'django.template.backends.django.DjangoTemplates',
                    'DIRS': [],
                    'APP_DIRS': True,
                    'OPTIONS': {
                        'context_processors': [
                            'django.template.context_processors.debug',
                            'django.template.context_processors.request',
                            'django.contrib.auth.context_processors.auth',
                            'django.contrib.messages.context_processors.messages',
                        ],
                    },
                },
            ],

            "__file__": '/Users/Ming/Documents/Nuwa_mercurius/Projects/TemplatesShop/TemplatesShop/settings.pyc',
        }


        
         # Iuno.shop 
        IUNO_SHOP_ENABLE = True
        Iuno.attachSettings(settingsContent)
        
        templatesSettings = {
            'TEMPLATES' : [
                {
                    'BACKEND': 'django.template.backends.django.DjangoTemplates',
                    'DIRS': [os.path.join(BASE_DIR, 'templates'),
                            
                            OSCAR_MAIN_TEMPLATE_DIR, ],
                    'APP_DIRS': True,
                    'OPTIONS': {
                        'context_processors': [
                            'django.template.context_processors.debug',
                            'django.template.context_processors.request',
                            'django.contrib.auth.context_processors.auth',
                            'django.contrib.messages.context_processors.messages',
                            
                            'oscar.apps.search.context_processors.search_form',
                            'oscar.apps.promotions.context_processors\
                            .promotions',
                            'oscar.apps.checkout.context_processors.checkout',
                            'oscar.apps.customer.notifications.\
                            context_processors.notifications',
                            'oscar.core.context_processors.metadata',
                        ],
                    },
                },
            ]
        }
        self.assertEqual(settingsContent['TEMPLATES'],
                         templatesSettings['TEMPLATES'])

if __name__ == "__main__":
    testAttachSettings = TestAttachSettings()
    testAttachSettings.runTest()