#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: cms_dumpdata.py 10809 2018-03-04 09:29:56Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-03-04 17:29:56 +0800 (週日, 04 三月 2018) $
# $Revision: 10809 $

import os
import sys
import json

from StringIO import StringIO

from django.core.management.base import BaseCommand
from django.core import serializers
from django.db.models import get_app, get_models
from django.db.models.query import QuerySet

class Command(BaseCommand):

    help = 'Dump all data include filer.File to initial_data.json'

    def add_arguments(self, parser):
        parser.add_argument('path', type=str, help="path")
        parser.add_argument(
            '-n', '--noAuth', 
            action='store_true',
            help="No export auth data.")
    
    def handle(self, *args, **options):
        app = get_app('filer')
        
        modelList = get_models(app)
        
        dataStream = StringIO()
        
        def getObjects():
            for model in modelList:
                model.objects.queryset_class = QuerySet
                for obj in model.objects.iterator():
                    yield obj
                    
        
        serializers.serialize(
            'json', getObjects(), indent=2, 
            use_natural_keys=True, stream=dataStream)
                
        filerData = json.loads(dataStream.getvalue())
        
        os.system(
            "%s manage.py dumpdata auth > authData.json" %  
            sys.executable)

        os.system(
            "%s manage.py dumpdata cms.Treenode > treenodeData.json" %  
            sys.executable)
            
        os.system(
            ("%s manage.py dumpdata "
             "-e auth -e filer -e contenttypes -e cms.Treenode "
             "> otherData.json") % 
             sys.executable)
        
        with open('authData.json') as f:
            content = f.read()
            authData = json.loads(content[content.index('['):])
        with open('treenodeData.json') as f:
            content = f.read()
            treenodeData = json.loads(content[content.index('['):])
        with open('otherData.json') as f:
            content = f.read()
            otherData = json.loads(content[content.index('['):])

        data = []

        if not options['noAuth']:
            for ele in authData:
                data.append(ele)

        
        for ele in filerData:
            data.append(ele)
        for ele in treenodeData:
            data.append(ele)
        for ele in otherData:
            data.append(ele)

        path = os.path.join(options['path'])

        with open(path, 'w') as f:
            content = f.write(json.dumps(data))
        os.remove('authData.json')
        os.remove('treenodeData.json')
        os.remove('otherData.json')
