#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 11055 2018-05-14 09:46:32Z Lavender $
#
# Copyright (c) 2018 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2018-05-14 17:46:32 +0800 (週一, 14 五月 2018) $
# $Revision: 11055 $

from django.conf.urls import url, patterns, include
from django.contrib.sitemaps.views import sitemap

from Zephyrus.seo.Sitemaps import sitemaps

def attachURLs(settings, urlpatterns):
    """
    Attach patched (for example, debug and admin...etc.) urlpatterns.
    It must be called in urls.py by passing urlpatterns.

    @param settings Django project's settings module.
    @param urlpatterns urlpatterns in urls.py.
    """
    
    urlpatterns += patterns('',
        url(r'^sitemap\.xml$', sitemap, {'sitemaps': sitemaps}),
        url(r'^robots\.txt', include('robots.urls')),
    )

