#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 11102 2018-06-10 11:59:41Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-06-10 19:59:41 +0800 (週日, 10 六月 2018) $
# $Revision: 11102 $

import urllib
import re
import unicodedata

from django.contrib import admin
from django.conf import settings
from django.utils.safestring import mark_safe
from django.utils.encoding import force_text
from django.utils.translation import ugettext_lazy as _
from aldryn_newsblog.admin import ArticleAdmin
from aldryn_newsblog.models import Article
from djangocms_text_ckeditor.models import Text

from Zephyrus.blog_extension import views


def slugify(value): 
    # http://jrgraphix.net/research/unicode_blocks.php
    value = re.sub(
        ur'[\u0021-\u002F\u003A-\u0040\u2000-\u206f'
        ur'\u3000-\u303f\uff00-\uffef\uFE50-\uFE6F]+', '', value)
    
    return re.sub(r'[-\s]+', '-', value)

class ArticleAdmin2(ArticleAdmin):
    fieldsets = (
        (None, {
            'fields': (
                'title',
                'author',
                'publishing_date',
                'is_published',
                'is_featured',
                'featured_image',
            )
        }),
        (_('Meta Options'), {
            'classes': ('collapse',),
            'fields': (
                # 'slug',
                'meta_title',
                'meta_description',
                'meta_keywords',
            )
        }),
        (_('Advanced Settings'), {
            'classes': ('collapse',),
            'fields': (
                'tags',
                'categories',
                'related',
                'owner',
                'app_config',
            )
        }),
    )

    def response_add(self, request, obj, post_url_continue=None):
        body = _("double click here to edit article content")
        textPlugin = Text.objects.create(
            placeholder=obj.content,
            language=obj.language_code,
            body=body, plugin_type='TextPlugin')
        obj.slug = slugify(obj.title)
        obj.save()
        
        return super(ArticleAdmin2, self).response_add(
            request, obj, post_url_continue=None)

    def response_change(self, request, obj):
        
        obj.slug = slugify(obj.title)
        
        obj.save()
        return super(ArticleAdmin2, self).response_change(request, obj)

admin.site.unregister(Article)
admin.site.register(Article, ArticleAdmin2)
