#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 11070 2018-05-21 10:34:25Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-05-21 18:34:25 +0800 (週一, 21 五月 2018) $
# $Revision: 11070 $

from django.db import models
from django.conf import settings
from django.utils.translation import ugettext_lazy as _
from cms.models import CMSPlugin
from aldryn_categories.models import Category
from taggit.models import Tag

from Zephyrus.blog_extension import settings as _settings

METHODS = [
    ('or',  _('OR')),
    ('and',  _('AND')),
]

class FilterPlugin(CMSPlugin):
    limit = models.PositiveIntegerField(_('Limit'), default=6)

    filterMethod = models.CharField(
        _('Filter Method'), max_length=3, choices=METHODS, default='or')

    tag = models.ManyToManyField(
        Tag,
        verbose_name=_('Tag'),
        default=None,
        blank=True,
        null=True,
    )

    catagory = models.ForeignKey(
        Category,
        verbose_name=_('Catagory'),
        on_delete=models.CASCADE,
        related_name='+',
        default=None,
        blank=True,
        null=True,
    )

    renderTemplate = models.CharField(
        _('Render template'), max_length=150,
        choices=_settings.ZEPHYRUS_BLOG_MAYLIKE_TEMPLATES,
        default=_settings.ZEPHYRUS_BLOG_MAYLIKE_DEFAULT_TEMPLATE,
    )

