#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 9948 2017-05-07 06:08:11Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-05-07 14:08:11 +0800 (�g��, 07 ���� 2017) $
# $Revision: 9948 $

from django.conf import settings as _settings
from django.utils.translation import ugettext_lazy as _

class settings(object):
    ZEPHYRUS_FACEBOOK_FAN_DEFAULT_TEMPLATE = \
        "facebook/FacebookFanPlugin.html"
    ZEPHYRUS_FACEBOOK_PHOTO_DEFAULT_TEMPLATE = \
        "facebook/FacebookPhotoPlugin.html"

    ZEPHYRUS_FACEBOOK_FAN_TEMPLATES = [
        (ZEPHYRUS_FACEBOOK_FAN_DEFAULT_TEMPLATE, _("Default")),
    ]

    ZEPHYRUS_FACEBOOK_PHOTO_TEMPLATES = [
        (ZEPHYRUS_FACEBOOK_PHOTO_DEFAULT_TEMPLATE, _("Default")),
    ]

    if hasattr(_settings, 'ZEPHYRUS_FACEBOOK_FAN_TEMPLATES'):
        for ele in _settings.ZEPHYRUS_FACEBOOK_FAN_TEMPLATES:
            if not ele[0] == "facebook/FacebookFanPlugin.html":
                ZEPHYRUS_FACEBOOK_FAN_TEMPLATES.append(ele)

    if hasattr(_settings, 'ZEPHYRUS_FACEBOOK_PHOTO_TEMPLATES'):
        for ele in _settings.ZEPHYRUS_FACEBOOK_PHOTO_TEMPLATES:
            if not ele[0] == "facebook/FacebookPhotoPlugin.html":
                ZEPHYRUS_FACEBOOK_PHOTO_TEMPLATES.append(ele)
