#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: urls.py 9579 2016-03-09 01:43:46Z Judy $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Judy $
# $Date: 2016-03-09 09:43:46 +0800 (三, 09  3 2016) $
# $Revision: 9579 $

from django.conf.urls import url, patterns

from Theophrastus.cloud import views

urlpatterns = patterns('',
    url(r'^bounces/$', views.getBounces,
        name='Theophrastus.cloud.getBounces'),
    url(r'^complains/$', views.getComplains,
        name='Theophrastus.cloud.getComplains'),

    url(r'^verify/$', views.verifyEmailAddress,
        name='Theophrastus.cloud.ajax.verifyEmailAddress'),
    url(r'^verify/delete/$', views.deleteVerifiedEmailAddress,
        name='Theophrastus.cloud.ajax.deleteVerifiedEmailAddress'),
    url(r'^verify/check/$', views.checkVerifiedEmailAddress,
        name='Theophrastus.cloud.ajax.checkVerifiedEmailAddress'),

    url(r'^notificationTopic/set/$', views.setNotificationTopic,
        name='Theophrastus.cloud.ajax.setNotificationTopic'),
)
