#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: ThankRedirect.py 9895 2017-04-23 04:33:47Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-04-23 12:33:47 +0800 (週日, 23 四月 2017) $
# $Revision: 9895 $

from django import template
from django.utils.safestring import mark_safe
from django.conf import settings
from django.template.loader import get_template
from django.template import Context

from Zephyrus.landing import getErrorMessage

register = template.Library()

@register.simple_tag
def ThankRedirect(request):
    fromUrl = request.GET.get('from_url')
    errorCode = int(request.GET.get('error'))
    if fromUrl == None:
        return ''
    
    if hasattr(settings, 'ZEPHYRUS_LANDING_THANK_WAIT_TIME'):
        time = settings.ZEPHYRUS_LANDING_THANK_WAIT_TIME
    else:
        time = 3000

    errorHtml = get_template('landing/ErrorMessage.html')
    errorMessage = getErrorMessage(errorCode)
    print errorMessage
    errorHtml = errorHtml.render(
            Context({'errorMessage': errorMessage,})
        )
    print errorHtml
    
    return mark_safe(
        '''
        %s
        <script>
            var redirect = function(){
                setTimeout(function(){window.location.replace('%s');}, %d);
            };
            redirect();
        </script>
        ''' % (errorHtml, fromUrl, time)
    )
