#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 9913 2017-04-24 13:07:32Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-04-24 21:07:32 +0800 (週一, 24 四月 2017) $
# $Revision: 9913 $

import datetime
import logging
import urllib

from django.shortcuts import redirect
from django.contrib import messages
from django.views.generic import View
from django.core.mail import send_mail
from django.conf import settings
from django.template.loader import get_template
from django.template import Context
from django.contrib import auth
from django.core.validators import validate_email
from django.core.exceptions import ValidationError

from Zephyrus.landing import ErrorCode
from Zephyrus.landing.models import Email

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)
logger.addHandler(logging.StreamHandler())

def sendAndRedirect(request, email, fromUrl, redirectTo):
        errorCode = ErrorCode.NORMAL
          
        try:
            validate_email(email)
            try:
                email = Email.objects.create(
                    email=email,
                    fromUrl=fromUrl,    
                )
                email.save()
            except Exception as e:
                errorCode = ErrorCode.SAVE_EMAIL
                logger.error('Not successfully save email: %s' % str(e))

            try:
                message = (
                    "Customer id : %d\nCustomer email : %s\n" % 
                    (email.id, email.email))
                message += "Date : %s" % datetime.datetime.now()
                message += "From : %s" % fromUrl
                
                title = (
                    '[Landing %s] - customer use landing page' % 
                    request.META['HTTP_HOST'])
                    
                send_mail(
                    title,
                    message,
                    settings.EMAIL_HOST_USER,
                    settings.ZEPHYRUS_LANDING_SEND_TO,
                    fail_silently=False
                )
                
                mail = get_template('landing/ThankEmail.txt')
                replaceStr = Context({
                    'email': email.email,
                })
                
                title = get_template('landing/ThankEmailSubject.txt')
                
                send_mail(
                    title.render(),
                    mail.render(replaceStr),
                    settings.EMAIL_HOST_USER,
                    [email.email,],
                    fail_silently=False
                )
            except Exception as e:
                errorCode = ErrorCode.SEND_EMAIL
                logger.error('Not successfully send email: %s' % str(e))
        except ValidationError as e:
            errorCode = ErrorCode.EMAIL_FORMAT 
            logger.error('Email format error: %s' % str(e))
        
        if redirectTo:        
            url = urllib.quote(redirectTo)
        else:
            if hasattr(settings, "ZEPHYRUS_LANDING_THANK_URL"):
                url = fromUrl + settings.ZEPHYRUS_LANDING_THANK_URL
            else:
                url = fromUrl + "thank"
            
        url = url + "?from_url=%s&error=%d" % (fromUrl, errorCode)

        return redirect(url)
    
class EmailView(View):  
    def post(self, request, *args, **kwargs):
        email = request.POST.get('email')
        fromUrl = request.POST.get('fromUrl')
        redirectTo = request.POST.get('redirectTo')
        return sendAndRedirect(request, email, fromUrl, redirectTo)
            
class LandingSocialView(View):
    def get(self, request, *args, **kwargs):
        user = request.user
        email = user.email
        fromUrl = request.GET.get('fromUrl')
        redirectTo = request.GET.get('redirectTo')
        auth.logout(request)
        return sendAndRedirect(request, email, fromUrl, redirectTo)