#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 11641 2019-06-19 07:33:01Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-06-19 15:33:01 +0800 (週三, 19 六月 2019) $
# $Revision: 11641 $

from django.db.models.signals import post_save
from django.dispatch import receiver

from Zephyrus.facebook.models import APIData
from Zephyrus.statistics.models import URL
from Zephyrus.comment.models import CommentConfig, Comment

@receiver(post_save, sender=Comment)
def updateCommentCount(sender, instance, **kwargs):
    obj, created = URL.objects.get_or_create(
        url=instance.url,
    )
    config, created = CommentConfig.objects.get_or_create(
        url=instance.url,
        defaults={'useFbComment': False},
    )

    # 處理我們自己的commentCount
    if not config.useFbComment:
        count = Comment.objects.filter(url=instance.url, display=True).count()
        obj.commentCount = count
        obj.save()

