#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 9754 2017-02-18 05:34:31Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-02-18 13:34:31 +0800 (?g??, 18 ?G?? 2017) $
# $Revision: 9754 $

from django import template

from Zephyrus.facebook.templatetags.Facebook import getApiData
from Zephyrus.comment.models import CommentConfig, Comment

register = template.Library()

@register.simple_tag(takes_context=True)
def commentCount(context, url=None):
    request = context['request']
    if url:
        if not url.startswith('http'): 
            url = request.build_absolute_uri('/')[:-1].strip("/") + url
    else:
        url = request.build_absolute_uri(request.path)

    obj, created = CommentConfig.objects.get_or_create(
        url=url,
        defaults={'useFbComment': False},
    )
    if obj.useFbComment:
        count = getApiData(url, "comment_count")
    else:
        count = Comment.objects.filter(url=url).count()
    
    if count:
        return count
    return 0