#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: cms_plugins.py 11178 2018-07-22 12:34:44Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-07-22 21:34:44 +0900 (週日, 22 七月 2018) $
# $Revision: 11178 $

from django.utils.translation import ugettext as _
from cms.plugin_base import CMSPluginBase
from cms.plugin_pool import plugin_pool

from Zephyrus.line.models import Transmission, BeFriend, ShareLike

class TransmissionPlugin(CMSPluginBase):
    model = Transmission
    module = _("Zephyrus Line")
    name = _("Line Transmission")
    render_template = "line/Transmission.html"

    def render(self, context, instance, placeholder):
        request = context['request']

        if instance.url == '':
            url = request.build_absolute_uri()
        else:
            url = instance.url

        context.update({
            'url': url,
            'obj': instance,
        })

        return context

class BeFriendPlugin(CMSPluginBase):
    model = BeFriend
    module = _("Zephyrus Line")
    name = _("Line BeFriend")
    render_template = "line/BeFriend.html"

    def render(self, context, instance, placeholder):
        context.update({
            'obj': instance,
        })
        return context

class LineShareLikePlugin(CMSPluginBase):
    model = ShareLike
    module = _("Zephyrus Line")
    name = _("Line ShareLike")
    render_template = "line/ShareLike.html"

    def render(self, context, instance, placeholder):
        request = context['request']

        if instance.url == '':
            url = request.build_absolute_uri()
        else:
            url = instance.url

        context.update({
            'url': url,
            'obj': instance,
        })

        return context

plugin_pool.register_plugin(TransmissionPlugin)
plugin_pool.register_plugin(BeFriendPlugin)
plugin_pool.register_plugin(LineShareLikePlugin)