#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 9754 2017-02-18 05:34:31Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-02-18 13:34:31 +0800 (?g??, 18 ?G?? 2017) $
# $Revision: 9754 $

import os
import datetime

from django import template

register = template.Library()

def getFileData(node, dataName):
    fullPath = node.absolutePath

    if dataName == 'mtime':
        return datetime.datetime.fromtimestamp(os.stat(fullPath).st_mtime)
    elif dataName == 'size':
        return os.stat(fullPath).st_size
    else:
        return None

register.filter('getFileData', getFileData)
