#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: clean_version.py 11172 2018-07-16 09:31:00Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-07-16 17:31:00 +0800 (Mon, 16 Jul 2018) $
# $Revision: 11172 $

import os
import shutil

from django.core.management.base import BaseCommand

from Iuno.template_editor import BACKUP_FILE_DIR
from Iuno.template_editor.models import Version

class Command(BaseCommand):

    def handle(self, *args, **options):
        # delete all version
        Version.objects.all().delete()

        # delete backup file
        shutil.rmtree(BACKUP_FILE_DIR)

        if not os.path.isdir(BACKUP_FILE_DIR):
            os.mkdir(BACKUP_FILE_DIR)
        print "Successfully."