#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: setup.py 11315 2018-12-14 05:41:20Z Kevin $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Kevin $ (last)
# $Date: 2018-12-14 13:41:20 +0800 (??, 14 ??? 2018) $
# $Revision: 11315 $

import os
import warnings

try:
    from Iuppiter.DistUtil import setup
    from Iuppiter.Util import colored
except ImportError:
    os.system('pip install Iuppiter --no-cache-dir')
    from Iuppiter.DistUtil import setup
    from Iuppiter.Util import colored
    
import sys

if sys.version_info.major == 3:
    extraRequirements = [
        'pip install mysqlclient==1.3.12',
    ]
else:
    extraRequirements = [
        'pip install mysqlclient==1.3.7',
    ]

if sys.version_info[:2] >= (3, 6):
    warnings.warn("%s" % (
        colored("Celery 3.1 does not support Python 3.6, \n"
                "See: https://code.nuwainfo.com/trac/Mercurius/ticket/3009",
                'yellow', attrs=['bold'])))

from sys import platform as _platform

# Python for Window Extensions (pypiwin32) is only for Windows.
if _platform == "win32":
    # win32 (https://pypi.python.org/pypi/pypiwin32/219)
    extraRequirements.append('pip install pypiwin32')    

setup(
    'Iuno',
    description="Support package for all Nuwa Information's server projects.",
    version='%s.%s' % ('3.2.12', "$Revision: 11315 $"[11:-2]),
    license='Proprietary License',
    author='Bear',
    author_email='bear@nuwainfo.com',
    url='http://www.nuwainfo.com/',
	extraRequirements=extraRequirements,
    extrasRequire={
        'scrapy': "REQUIREMENTS_SCRAPY.txt",
    }
)
