#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 10797 2018-03-01 02:31:02Z David $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $
# $Date: 2018-03-01 10:31:02 +0800 (Thu, 01 Mar 2018) $
# $Revision: 10797 $

from django.db.models import Max as modelsMax
from django.contrib.admin.views.decorators import staff_member_required
from django.http import Http404

from Iuppiter.extension.views import view, jsonpCallback

from emencia.django.newsletter.models import ContactMailingStatus, Newsletter

from Theophrastus.statistics.StatisticsHandler import getStartDateEndDate
from Theophrastus.statistics.StatisticsHandler import getStatisticsTotalData
from Theophrastus.statistics.StatisticsHandler import getStatisticsTotalRateData
from Theophrastus.statistics.StatisticsHandler import getSubscriberHistory

def getNewsletterOr404(slug):
    try:
        return Newsletter.objects.get(slug=slug)
    except:
        raise Http404

@jsonpCallback()
def getTotalData(request, slug):
    """
    Get statistics of subscriber's every rates.

    @param slug Newsletter slug.
    @param request Request instance.
    """
    newsletter = getNewsletterOr404(slug)

    subscriberCount = newsletter.mailing_list.subscribers_count()
    testSubscriberCount = newsletter.mailing_list.subscribers.filter(
        tester=True).count()

    conditions = {'newsletter': newsletter}
    response = getStatisticsTotalData(request.GET, subscriberCount, 
                                      testSubscriberCount, conditions)
    return response

@jsonpCallback()
def getTotalRateData(request, slug):
    """
    Get statistics of subscriber's every rates.

    @param slug Newsletter slug.
    @param request Request instance.
    """
    newsletter = getNewsletterOr404(slug)

    subscriberCount = newsletter.mailing_list.subscribers_count()
    testSubscriberCount = newsletter.mailing_list.subscribers.filter(
        tester=True).count()

    conditions = {'newsletter': newsletter}
    response = getStatisticsTotalRateData(
        request.GET, subscriberCount, testSubscriberCount, conditions)
    return response

@jsonpCallback()
def getHistory(request, slug):
    """
    Get history data of subscribers.

    @param slug Slug.
    """
    newsletter = getNewsletterOr404(slug)
    condition = {'newsletter': newsletter}
    status = request.GET.get('status', '')
    if status:
        condition.update({'status': int(status)})

    keyword = request.GET.get('keyword', '')
    if keyword:
        condition.update({'contact__email__icontains': keyword})

    response = getSubscriberHistory(request.GET, condition)
    return response

@staff_member_required
@view('Statistics.html')
def displayStatistics(request, slug):
    """
    Get statistics of subscriber's every rates.

    @param slug Newsletter slug.
    @param request Request instance.
    """
    newsletter = Newsletter.objects.get(slug=slug)
    startDate, endDate = getStartDateEndDate()
    return {'newsletter': newsletter, 
            'startDate' : startDate,
            'endDate' : endDate}

@staff_member_required
@view('Subscribers.html')
def displaySubscribers(request, slug):
    """
    Get statistics of subscriber's every rates.

    @param slug Newsletter slug.
    @param request Request instance.
    """
    newsletter = Newsletter.objects.get(slug=slug)
    _status = dict(ContactMailingStatus.STATUS_CHOICES)
    return {
        'newsletter': newsletter,
        'statusNames': _status.values(),
        'statusCode': _status.keys(),
    }
