#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: AttachSettings.py 11595 2019-05-29 06:39:53Z Andy $
#
# Copyright (c) 2013 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Andy $
# $Date: 2019-05-29 14:39:53 +0800 (週三, 29 五月 2019) $
# $Revision: 11595 $

import os

def attachSettings(settingsDict):

    installed = settingsDict['INSTALLED_APPS']

    if 'Theophrastus' in installed:

        def attachAttrs(attrs):
            for attr in attrs:
                name, _v = attrs[attr]
                _attr = settingsDict.get(attr, _v)
                settingsDict[name] = _attr

        CURRENT_PATH = os.path.dirname(__file__)

        #=======================================================================
        # Attach TEMPLATE_DIRS.
        #=======================================================================

        THEOPHRASTUS_TEMPLATE_DIRS = settingsDict.get(
            'THEOPHRASTUS_TEMPLATE_DIRS',
            os.path.join(CURRENT_PATH, 'templates')
        )

        templateDirs = list(settingsDict['TEMPLATES'][0]['DIRS'])
        templateDirs.extend([THEOPHRASTUS_TEMPLATE_DIRS])
        settingsDict['TEMPLATES'][0]['DIRS'] = tuple(templateDirs)
        
        
        #=======================================================================
        # Attach STATIC_DIRS.
        #=======================================================================
        THEOPHRUSTUS_STATIC_DIRS = settingsDict.get(
             'THEOPHRUSTUS_STATIC_DIRS',
             os.path.join(CURRENT_PATH, 'static')
             )    
        if settingsDict.get('STATICFILES_DIRS') == None:
            staticDirs = []
        else:
            staticDirs = list(settingsDict.get('STATICFILES_DIRS'))
        staticDirs.extend([THEOPHRUSTUS_STATIC_DIRS])
        settingsDict['STATICFILES_DIRS'] = tuple(staticDirs)
        
        
        #=======================================================================
        # Attach TINYMCE_DEFAULT_CONFIG.
        #=======================================================================        
        if not settingsDict.has_key('TINYMCE_DEFAULT_CONFIG'):
            settingsDict['TINYMCE_DEFAULT_CONFIG'] = {
                'plugins':
                    "facebook,autolink,lists,spellchecker,pagebreak,style,layer,table,save"
                    ",advhr,advimage,advlink,emotions,iespell,inlinepopups,"
                    "insertdatetime,preview,media,searchreplace,print,contextmenu,"
                    "paste,directionality,fullscreen,noneditable,visualchars,"
                    "nonbreaking,xhtmlxtras,template,upload,variablePlugin",
                'relative_urls': False,
                'remove_script_host': False,
                'skin_variant': "black",
                'style_formats': [{
                    'title' : 'Bold text',
                    'inline' : 'b'
                }, {
                    'title' : 'Red text',
                    'inline' : 'span',
                    'styles' : {'color' : '#ff0000'}
                }, {
                    'title' : 'Red header',
                    'block' : 'h1',
                    'styles' : {'color' : '#ff0000'}
                }],

                #'formats': {"test": {"title" : 'Table row 1', "selector" : 'tr', "classes" : 'tablerow1'}},
                'theme': "advanced",
                'theme_advanced_buttons1': "save,newdocument,|,bold,italic,underline,"
                                           "strikethrough,|,justifyleft,justifycenter,"
                                           "justifyright,justifyfull,|,styleselect,"
                                           "formatselect,fontselect,fontsizeselect,"
                                           "template,|,link,unlink,image,|,",
                'theme_advanced_buttons2': "cut,copy,paste,pastetext,pasteword,|,search,"
                                           "replace,|,bullist,numlist,|,outdent,indent,"
                                           "blockquote,|,undo,redo,|,"
                                           "upload,cleanup,code,|,insertdate,"
                                           "inserttime,preview,|,forecolor,backcolor",
                'theme_advanced_buttons3': "tablecontrols,|,hr,removeformat,visualaid,|,"
                                           "sub,sup,|,charmap,iespell,media,advhr,|,"
                                           "insertlayer,moveforward,movebackward,absolute,"
                                           "|,styleprops,spellchecker,",
                'theme_advanced_buttons4': "fullscreen,print,feed,variablePlugin,|,",
                'theme_advanced_toolbar_location': "top",
                'theme_advanced_toolbar_align': "left",
                'theme_advanced_statusbar_location': "bottom",
                'theme_advanced_resizing': True,

                # Skin options
                'skin': "o2k7",
                'skin_variant': "silver",

                # Example content CSS (should be your site CSS)
                #'content_css' : "css/example.css",

                # Drop lists for link/image/media/template dialogs
                #'template_external_list_url': "%sjs/TemplateExternalList.js" % MEDIA_URL,
                #'external_link_list_url': "js/link_list.js",
                #'external_image_list_url': "js/image_list.js",
                #'media_external_list_url': "js/media_list.js",

                # Replace values for the template plugin
                'template_replace_values': {
                    'username': "Some User",
                    'staffid': "991234"
                },

                'template_templates': [],
            }
        
        #=======================================================================
        # Attach INSTALLED_APPS.
        #=======================================================================

        installedApps = settingsDict.get('THEOPHRASTUS_INSTALLED_APPS', [            
            # django-selectable
            'selectable',
            # django-modeladmin-reorder
            'admin_reorder',  
            
            'emencia.django.newsletter',
            
            'Theophrastus.api',
            'Theophrastus.newsletter_extension',
            'Theophrastus.editor',
            'Theophrastus.statistics',

            'Theophrastus.document',
             # Mailer in cloud app need Header, Footer in newsletter_extension
             # to send newsletters.
            'Theophrastus.cloud',
        ])
        # integration and api app depends on  statistics app
        if settingsDict.get('THEOPHRASTUS_ENABLE_INTEGRATION', False):
            installedApps.append('Theophrastus.integration')
            

        index = installed.index('Theophrastus')
        startApps = list(installed[:index])
        endApps = list(installed[index + 1:])

        startApps.extend(installedApps)
        startApps.extend(endApps)
        settingsDict['INSTALLED_APPS'] = tuple(startApps)

        attachAttrs(attrs={
            'THEOPHRASTUS_ENABLE_INTEGRATION': ('ENABLE_INTEGRATION', False),
        })


        #=======================================================================
        # Attach editor middleware settings.
        #=======================================================================

        # django-modeladmin-reorder
        middlewareClasses = settingsDict['MIDDLEWARE_CLASSES']
        middlewareClasses += ('admin_reorder.middleware.ModelAdminReorder', )
        settingsDict['MIDDLEWARE_CLASSES'] = middlewareClasses

        #=======================================================================
        # Attach editor template settings.
        #=======================================================================

        attachAttrs(attrs={
            # Set upload path.
            'THEOPHRASTUS_TEMPLATE_DIR_PATH': (
                'TEMPLATE_DIR_PATH',
                'editor/tinymceTemplate/'
            ),
        })

        #=======================================================================
        # Attach upload settings.
        #=======================================================================

        attachAttrs(attrs={
            # Set upload path.
            'THEOPHRASTUS_UPLOAD_PATH': (
                'UPLOAD_PATH',
                os.path.join(settingsDict['MEDIA_ROOT'], 'uploads')
            ),
            # Set upload extra number.
            'THEOPHRASTUS_UPLOAD_EXTRA': ('UPLOAD_EXTRA', 3),
        })

        #=======================================================================
        # Mailer.
        #=======================================================================
        import logging

        attachAttrs(attrs={
            'THEOPHRASTUS_LOG_LEVEL': (
                'LOG_LEVEL', logging.INFO
            ),
            # Enable fake send mode.
            'THEOPHRASTUS_ENABLE_FAKE_MAIL': (
                'ENABLE_FAKE_MAIL', False
            ),
            # Enable fake SMTP connection.
            'THEOPHRASTUS_ENABLE_FAKE_SMTP': (
                'ENABLE_FAKE_SMTP', False
            ),
            # Set log file for mail server.
            'THEOPHRASTUS_MAIL_SERVER_LOGFILE': (
                'MAIL_SERVER_LOGFILE',
                os.path.join(CURRENT_PATH, 'mailServer.log')
            ),
            # Set log file for apscheduler.
            'THEOPHRASTUS_APSCHEDULER_LOGFILE': (
                'APSCHEDULER_LOGFILE',
                os.path.join(CURRENT_PATH, 'apscheduler.log')
            ),
            # Set log file for apscheduler.
            'THEOPHRASTUS_ENABLE_APSCHEDULER_LOGFILE': (
                'ENABLE_APSCHEDULER_LOGFILE', False
            ),
            # Set log file for mailer.
            'THEOPHRASTUS_MAILER_LOGFILE': (
                'MAILER_LOGFILE',
                os.path.join(CURRENT_PATH, 'mailer.log')
            ),
            # Set mailer thread pool counts.
            'THEOPHRASTUS_MAILER_THREAD_POOL_COUNT': (
                'MAILER_THREAD_POOL_COUNT', 10
            ),
            # Set sendbox thread pool counts.
            'THEOPHRASTUS_SENDBOX_THREAD_POOL_COUNT': (
                'SENDBOX_THREAD_POOL_COUNT', 25
            ),
            'THEOPHRASTUS_SEND_FAILED_COUNT': (
                'SEND_FAILED_COUNT', 3
            ),
            'THEOPHRASTUS_WAITTING_TIMEOUT': (
                'WAITTING_TIMEOUT', 6
            ),
        })

        #=======================================================================
        # API.
        #=======================================================================

        attachAttrs(attrs={
            # Set log file for api.
            'THEOPHRASTUS_API_LOG': (
                'API_LOG',
                os.path.join(CURRENT_PATH, 'api.log')
            ),
        })

        #=======================================================================
        # Amazon web service.
        #=======================================================================

        AWS_ACCESS_KEY_ID = 'AKIAIS2EYEZOZEPAZE7Q'
        AWS_SECRET_ACCESS_KEY = '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'

        attachAttrs(attrs={
            # Set access key id.
            'AWS_ACCESS_KEY_ID': (
                'AWS_ACCESS_KEY_ID', AWS_ACCESS_KEY_ID
            ),
            # Set secret key id.
            'AWS_SECRET_ACCESS_KEY': (
                'AWS_SECRET_ACCESS_KEY', AWS_SECRET_ACCESS_KEY
            ),
            # Set log.
            'THEOPHRASTUS_AMAZON_LOGFILE': (
                'AMAZON_LOGFILE', os.path.join(CURRENT_PATH, 'amazon.log')
            ),
        })

        #=======================================================================
        # Facebook.
        #=======================================================================

        attachAttrs(attrs={
            # Set access key id.
            'THEOPHRASTUS_FACEBOOK_FEED_APP_ID': (
                'FACEBOOK_FEED_APP_ID', '171864859549153'
            ),
        })

        #=======================================================================

        #=======================================================================
        # django-modeladmin-reorder.
        #=======================================================================
        adminReorderDict = {
            'THEOPHRASTUS_ADMIN_REORDER':(
                'ADMIN_REORDER', (
                    # Keep original label and models
                    'auth',      
                    'integration',        
                    'newsletter',
                    'newsletter_extension',
                    'sites',
                ),
            ),
        }

        attachAttrs(attrs=adminReorderDict)
        
        # Use workgroups to manage auth of user which is staff but not admin.
        if not 'NEWSLETTER_USE_WORKGROUPS' in settingsDict:
            settingsDict['NEWSLETTER_USE_WORKGROUPS'] = True
            
        from Iuno import Patch
        Patch.extendAll(settingsDict)
