#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 11660 2019-07-21 13:24:58Z Trista $
#
# Copyright (c) 2019 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Trista $ (last)
# $Date: 2019-07-21 22:24:58 +0900 (週日, 21 七月 2019) $
# $Revision: 11660 $

from django.contrib import admin
from Iuno.redirect.models import Redirect


class RedirectAdmin(admin.ModelAdmin):
    list_display = ('old_path', 'new_path')
    list_filter = ('site',)
    search_fields = ('old_path', 'new_path')
    radio_fields = {'site': admin.VERTICAL}

admin.site.register(Redirect, RedirectAdmin)

# patch
from django.contrib.redirects.models import Redirect as djangoRedirect
from django.contrib.redirects import middleware
from django.db.models.signals import post_save
from django.dispatch import receiver

middleware.Redirect = Redirect

@receiver(post_save, sender=djangoRedirect)
def updateRedirect(sender, instance, **kwargs):
    obj = Redirect.objects.create(
        site=instance.site,
        old_path=instance.old_path,
        new_path=instance.new_path,
    )
    obj.save()
