#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: start_app.py 12039 2020-04-04 08:25:59Z Lavender $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2020-04-04 16:25:59 +0800 (週六, 04 四月 2020) $
# $Revision: 12039 $

import os
import sys
import datetime
import shutil

from django.core.management.base import BaseCommand, CommandError
from django.template.loader import get_template
from django.template import Context
from django.core.management import call_command

from Iuppiter.Encoding import utf8

SCRAPY_PROJECT_NAME = "_IunoScaffold"

class Command(BaseCommand):
    
    help = 'Create project app and add our file header.'
    
    def add_arguments(self, parser):
        parser.add_argument('name', type=str, help="App name")
        parser.add_argument(
            '-s', '--scrapy', 
            action='store_true',
            help="Create scrapy app for django.")

    def handle(self, *args, **options):
        name = options['name']

        def findSettings(path):
            for root, dirs, files in os.walk(path):
                for f in files:
                    if f == 'settings.py':
                        return os.path.join(root, f)
            return None
        projectName = os.path.dirname(findSettings('.'))
        projectName = projectName[projectName.index("\\") + 1:]
        
        call_command('startapp', name)

        # add header
        context = {
            "year": datetime.date.today().year, 
        }
        temp = get_template('scaffold/HeaderTemplate.txt')
        header = temp.render(context)

        context = {
            "projectName": projectName, 
        }
        temp = get_template('scaffold/ScrapySettings.txt')
        scrapySettings = temp.render(context)

        for root, dirs, files in os.walk(os.path.join(name)):
            for f in files:
                path = os.path.join(root, f)
                if f == 'tests.txt':
                    os.remove(path)
                    continue
                
                with open(path, 'r') as f:
                    content = f.read()
                content = header + content
                with open(path, 'wb') as f:
                    f.write(utf8(content))

        if options['scrapy']:
            try:
                import scrapy
            except Exception as e:
                result = os.system("pip install scrapy")
            result = os.system("scrapy startproject %s" % SCRAPY_PROJECT_NAME)

            appPath = os.path.join(name)
            cfgPath = os.path.join(SCRAPY_PROJECT_NAME, "scrapy.cfg")

            with open(cfgPath, 'r') as f:
                content = f.read()
            with open(os.path.join("scrapy.cfg"), 'w') as f:
                f.write(content.replace(SCRAPY_PROJECT_NAME, name))

            for fileName in os.listdir(
                os.path.join(SCRAPY_PROJECT_NAME, SCRAPY_PROJECT_NAME)):
                filePath = os.path.join(
                    SCRAPY_PROJECT_NAME, SCRAPY_PROJECT_NAME, fileName)
                toPath = os.path.join(appPath, fileName)

                if os.path.isdir(filePath):
                    shutil.copytree(filePath, toPath)
                if os.path.isfile(filePath):
                    with open(filePath, 'rb') as f:
                        content = f.read()
                    content = utf8(header) + utf8(content)
                    if fileName.startswith("settings"):
                        content = content + utf8(str(scrapySettings))
                    with open(toPath, 'wb') as f:
                        f.write(content.replace(SCRAPY_PROJECT_NAME.encode(), name.encode()))

            with open("REQUIREMENTS.txt", 'r') as f:
                content = f.read()
            if not "scrapy" in content:
                content = content + "\nscrapy"
                with open("REQUIREMENTS.txt", 'w') as f:
                    f.write(content)

            shutil.rmtree(SCRAPY_PROJECT_NAME)
                

            
                    