#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: start_project.py 11244 2018-10-10 15:19:58Z Lavender $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-10-11 00:19:58 +0900 (週四, 11 十月 2018) $
# $Revision: 11244 $

import os
import configparser
import datetime

from django.core.management.base import BaseCommand, CommandError
from django.template.loader import get_template
from django.template import Context

class Command(BaseCommand):
    help = 'Create spider use Iuno.scrapy framework.'

    def add_arguments(self, parser):
        parser.add_argument('name', type=str, help="spider name")
        parser.add_argument('domain', type=str, nargs='?', help="domain name")

    def handle(self, *args, **options):
        name = options['name']
        domain = options['domain']
        
        if os.path.isfile('scrapy.cfg'):
            config = configparser.ConfigParser()
            config.read('scrapy.cfg')
            projectName = config.get('deploy', 'project')
            spiderPath = os.path.join(projectName, 'spiders', "%s.py" % name)
            
            if not os.path.isfile(spiderPath):
                temp = get_template('scaffold/Spider.txt')
                context = {
                    "year": datetime.date.today().year,
                    "name": name,
                    "domain": domain,
                }
                content = temp.render(context)
                
                with open(spiderPath, 'w') as f:
                    f.write(content)
            else:
                print("Spider file existed: %s" % name)
        else:
            print("This project isn't have scrapy.")
        
        