#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 11713 2019-09-18 13:42:53Z Lavender $
#
# Copyright (c) 2019 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2019-09-18 22:42:53 +0900 (週三, 18 九月 2019) $
# $Revision: 11713 $
#
# Contributors:
#  Bear (original author)
#  Yachu

from Iuno.Util import update

from Iuppiter.DjangoUtil import (
    extendInstalledApps, extendMiddlewareClasses)

def attachSettings(settingsLocals, backends, preferred, config):
    """
    Attach 'mail' related settings to settings.py.

    @param settingsLocals locals() in settings.py.
    @param backends Backend instances.
    @param preferred Preferred backends.
    @param config Configuration settings.
    """
    extendInstalledApps(settingsLocals, (
        'django_statsd',
        'Iuno.cloud.metrics',
    ))
    
    extendMiddlewareClasses(settingsLocals, [
        'django_statsd.middleware.StatsdMiddleware',
        ], 
        key='django.contrib.sessions.middleware.SessionMiddleware', 
        addBefore=True
    )
    
    extendMiddlewareClasses(settingsLocals, [
        'django_statsd.middleware.StatsdMiddlewareTimer',
    ])
    
    DEFAULT_STATSD_SETTINGS = {
        'STATSD_HOST': "statsd.nuwainfo.com",
        "STATSD_PORT": 8125,
    }
    
    update(settingsLocals, DEFAULT_STATSD_SETTINGS)

