# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import django.core.validators


class Migration(migrations.Migration):

    dependencies = [
        ('cms', '0016_auto_20160608_1535'),
        ('facebook', '0008_auto_20180514_1708'),
    ]

    operations = [
        migrations.CreateModel(
            name='FanPage',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(parent_link=True, related_name='facebook_fanpage', auto_created=True, primary_key=True, serialize=False, to='cms.CMSPlugin', on_delete=models.CASCADE)),
                ('url', models.URLField()),
                ('appId', models.CharField(max_length=20, verbose_name='Facebook API app ID')),
                ('width', models.PositiveIntegerField(default=340, verbose_name='Width', validators=[django.core.validators.MaxValueValidator(500), django.core.validators.MinValueValidator(180)])),
                ('height', models.PositiveIntegerField(default=500, verbose_name='Height', validators=[django.core.validators.MinValueValidator(70)])),
                ('tab', models.CharField(default=b'timeline', max_length=10, verbose_name='Tab', choices=[(b'timeline', 'Timeline'), (b'events', 'Events'), (b'messages', 'Messages')])),
                ('hideCover', models.BooleanField(default=False, verbose_name='Hide cover')),
                ('showFacepile', models.BooleanField(default=True, verbose_name='Show facepile')),
                ('hideCta', models.BooleanField(default=False, verbose_name='Hide cta')),
                ('smallHeader', models.BooleanField(default=False, verbose_name='Small header')),
                ('adaptContainerWidth', models.BooleanField(default=False, verbose_name='Adapt Container width')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
    ]
