#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: ThankRedirect.py 12418 2020-07-23 07:38:18Z Casey $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Casey $
# $Date: 2020-07-23 16:38:18 +0900 (週四, 23 七月 2020) $
# $Revision: 12418 $

from django import VERSION
from django import template
from django.utils.safestring import mark_safe
from django.conf import settings
from django.template.loader import get_template
from django.template import Context

register = template.Library()

@register.simple_tag
def ThankRedirect(request):
    fromUrl = request.GET.get('from_url')
    errorCode = int(request.GET.get('error', 0))
    if fromUrl == None:
        return ''
    
    if hasattr(settings, 'ZEPHYRUS_LANDING_THANK_WAIT_TIME'):
        time = settings.ZEPHYRUS_LANDING_THANK_WAIT_TIME
    else:
        time = 3000
    
    errorHtml = get_template('landing/ErrorMessage.html')
    
    if VERSION[0] == 1 and VERSION[1] == 11:
        errorHtml = errorHtml.render(
                {'errorCode': errorCode,}
        )
    else:
        errorHtml = errorHtml.render(
                {'errorCode': errorCode,}
        )
    
    return mark_safe(
        '''
        %s
        <script>
            var redirect = function(){
                setTimeout(function(){window.location.replace('%s');}, %d);
            };
            redirect();
        </script>
        ''' % (errorHtml, fromUrl, time)
    )
