#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: forms.py 10999 2018-04-30 07:30:23Z Lavender $
#
# Copyright (c) 2018 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2018-04-30 15:30:23 +0800 (週一, 30 四月 2018) $
# $Revision: 10999 $

from django import forms
from django.conf import settings

from oscar.core.loading import get_model, get_class
from ckeditor_uploader.widgets import CKEditorUploadingWidget

views = get_class('dashboard.catalogue', 'views')

Product = get_model('catalogue', 'Product')
_ProductForm = get_class('dashboard.catalogue.forms', 'ProductForm')

class ProductForm(_ProductForm):
    class Meta:
        model = Product
        fields = [
            'title', 'upc', 'description', 'is_discountable', 'structure']
            
        if hasattr(settings, 'IUNO_SHOP_PRODUCT_DESCRIPTION_CKEDITOR'):
            if settings.IUNO_SHOP_PRODUCT_DESCRIPTION_CKEDITOR:
                widgets = {
                    'structure': forms.HiddenInput(),
                    'description': CKEditorUploadingWidget(),
                }
            else:
                widgets = {
                    'structure': forms.HiddenInput(),
                    'description': forms.Textarea(attrs={'class': 'wysiwyg'}),
                }
        else:
            widgets = {
                'structure': forms.HiddenInput(),
                'description': forms.Textarea(attrs={'class': 'wysiwyg'}),
            }
            
views.ProductCreateUpdateView.form_class = ProductForm

