#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: middleware.py 11720 2019-09-23 06:12:17Z Lavender $
#
# Copyright (c) 2019 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-09-23 15:12:17 +0900 (週一, 23 九月 2019) $
# $Revision: 11720 $

from django.db import models
from django.utils.translation import ugettext_lazy as _

class Ban(models.Model):
    urlPattern = models.CharField(verbose_name=_("URL pattern"), max_length=255, db_index=True, unique=True)
    
    class Meta:
        verbose_name = _("Ban")
        verbose_name_plural = _("Ban")
        
class Keyword(models.Model):
    ban = models.ForeignKey(
        Ban,
        on_delete=models.CASCADE,
        related_name='keywords',
        verbose_name=_("Ban"),
    )
    
    column = models.CharField(verbose_name=_("Form column"), max_length=128, db_index=True)
    value = models.CharField(verbose_name=_("Value"), max_length=255)
    useRegularExpression = models.BooleanField(verbose_name=_("Use regular expression"), default=False)
    enable = models.BooleanField(verbose_name=_("Enable"), default=True)
    
    def __str__(self):
        return str(_("Keyword"))
    
    class Meta:
        verbose_name = _("Keyword")
        verbose_name_plural = _("Keyword")
    
    
    