#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Celery.py 9628 2016-04-10 15:06:01Z Eric $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Eric $
# $Date: 2016-04-10 23:06:01 +0800 (週日, 10 四月 2016) $
# $Revision: 9628 $

import inspect

from celery import Celery

from Iuno.browser import Config
from Iuno.browser import tasks

config = Config.load()

celery = Celery(__name__, include=[tasks.__name__])
celery.conf.update({
    'BROKER_URL': 'amqp://{user}:{password}'
                  '@{host}:{port}{vHost}'.format(
                   user=config.get('brokerUser', 'celery'),
                   password=config.get('brokerPassword', ''),
                   host=config.get('brokerHost', 'localhost'),
                   port=int(config.get('brokerPort', '5672')),
                   vHost=config.get('brokerVHost', '/'),                         
                  ),
    'CELERY_RESULT_BACKEND': 'redis://:{password}'
                             '@{host}:{port}'.format(
                              password=config.get('redisPassword', ''),
                              host=config.get('redisHost', 'localhost'),
                              port=int(config.get('brokerPort', '6379')),
                            ),
    'CELERY_TASK_SERIALIZER': 'pickle',
    'CELERY_RESULT_SERIALIZER': 'pickle',
    'CELERY_ACCEPT_CONTENT': ['pickle'],
})

# Register all tasks.
for name, value in inspect.getmembers(tasks):
    if inspect.isfunction(value) and value.__module__ == tasks.__name__:
        setattr(tasks, name, celery.task(value))

if __name__ == '__main__':
    celery.start()
