#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: RequestTest.py 9691 2016-06-26 07:32:08Z Bear $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Bear $
# $Date: 2016-06-26 15:32:08 +0800 (週日, 26 六月 2016) $
# $Revision: 9691 $
"""
Test Request trident implementation.
"""

import os
import sys

#p = os.path.abspath(os.path.join(os.path.dirname(__file__),
#                                 '..', '..', '..', '..'))
#sys.path.insert(0, p)

import unittest

from Iuno.tests.browser.RequestTestBase import _RequestTest

class RequestTest(_RequestTest):
    """
    Test case for Request.
    """

    ASSERT_DATA_DIR = os.path.dirname(__file__)

    def do(self, _url, options=None):
        """
        Do fetch.

        @param _url URL.
        @param options Options.
        @return Result.
        """
        return super(RequestTest, self).do(_url, 'trident', options=options)

    def testSingleThread(self):
        if not sys.platform.startswith('win'):
            return
        
        if not hasattr(self, 'ASSERT_DATA_DIR'):
            return

        _url = self.TEST_HOST_URL + '/'
        result = self.do(_url)

        self.assertEqual(result.url, _url)
        #self.assertEqual(result.lastModified, '11/20/2004 15:16:26')
        self.assertEqual(result.content, "<HTML><HEAD></HEAD>\r\n"
                                         "<BODY>\r\n"
                                         "<H1>It works!</H1></BODY></HTML>")
                                         
    def testSingleThreadMultiTimes(self):
        if not sys.platform.startswith('win'):
            return

        super(RequestTest, self).testSingleThreadMultiTimes()
        
    def testMultiThread(self):
        if not sys.platform.startswith('win'):
            return

        super(RequestTest, self).testMultiThread()        
        
    def testMultiThreadMultiTimes(self):
        if not sys.platform.startswith('win'):
            return

        super(RequestTest, self).testMultiThreadMultiTimes()       

    def testRSS(self):
        if not sys.platform.startswith('win'):
            return

        super(RequestTest, self).testRSS()          

    import re
    styleRE = re.compile('(style=".*")')
    extRE1 = re.compile('(ext-ie\d+)')
    extRE2 = re.compile('(ext-gen\d+)')

    def _nz(self, html):
        """
        Normalize got HTML source (strip \r, \n).

        @param html HTML source.
        @return Normalized source.
        """
        try:
            from tidylib import tidy_document
            document, errors = tidy_document(html, options={
                "output-xhtml": 1,
                "doctype": "omit",
                "lower-literals": 1,
                "sort-attributes": "alpha",
                "wrap-sections": 0,
                "wrap": 0,
                "drop-empty-paras": 1,
                "force-output": 1,
                "hide-comments": 1,
                "no-newline": 1,
                "strip-scripts": 1,
                "strip-styles": 1,
            })
            return self.extRE1.sub('', self.extRE2.sub('', document))
        except ImportError:
            z = html.replace('\r', '').replace('\n', '')
            z = self.styleRE.sub('', z)
            return self.extRE1.sub('', self.extRE2.sub('', z))

    #def testPost(self): NavigateError, unknown reason...
    #    pass

    #def testCookies(self): NavigateError, unknown reason...
    #    pass

    def testScript(self):
        if not sys.platform.startswith('win'):
            return    
    
        super(RequestTest, self)._testScript()

if __name__ == '__main__':
    unittest.main()
