#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: BlogExtension.py 12270 2020-05-26 04:48:53Z Trista $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Trista $
# $Date: 2020-05-26 12:48:53 +0800 (週二, 26 五月 2020) $
# $Revision: 12270 $

from django import template

register = template.Library()

# FIXME: 不知為何使用 {% allCategoryRoots categories %} 會在畫面上 render 出字來，
# 先暫時 return 空字串避免畫面 render 出不必要的字，然後使用 context 回傳值

@register.simple_tag(takes_context=True)
def allCategoryRoots(context, categories):
    roots = []
    parents = []
    for category in categories:
        root = category.get_root()
        if not root in roots:
            roots.append(root)
           
        parent = category
        while parent:
            if not parent in parents:
                parents.append(parent)
            parent = parent.get_parent()
    context['roots'] = roots
    context['parents'] = parents
    return ''
