#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: forms.py 12822 2021-03-30 10:54:46Z Becca $
#
# Copyright (c) 2018 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Becca $ (last)
# $Date: 2021-03-30 18:54:46 +0800 (週二, 30 三月 2021) $
# $Revision: 12822 $

from django import forms
from django.utils.translation import ugettext_lazy as _

from Zephyrus.cms_oscar.models import OscarFeatured, OscarLatest, OscarBestSeller
from oscar.core.loading import get_model

Product = get_model('catalogue', 'Product')

hasTags = False

if hasattr(Product, 'tags'):
    hasTags = True

    from taggit.models import Tag

    tagList = []
    try:
        for tag in Tag.objects.all():
            tagList.append((tag.id, tag.name))
    except Exception as e:
        pass

class OscarFeaturedForm(forms.ModelForm):
    if hasTags:
        tag = forms.MultipleChoiceField(
            choices=tagList,
            required=False,
            help_text=_(
                "If no choice. It will not filter product by tag.")
        )

    def __init__(self, *args, **kwargs): 
        super(OscarFeaturedForm, self) .__init__(*args, **kwargs) 
        if hasTags:
            if self.instance.tag:
                self.fields['tag'].initial = self.instance.tag.split(",")
            

    def save(self, commit=True):
        obj = super(OscarFeaturedForm, self).save(commit=commit)

        if hasTags:
            tags = ",".join(self.cleaned_data.get('tag', []))
            obj.tag = tags
            obj.save()

        return obj

    class Meta:
        model = OscarFeatured
        exclude = ['tag',]

class OscarLatestForm(forms.ModelForm):
    if hasTags:
        tag = forms.MultipleChoiceField(
            choices=tagList,
            required=False,
            help_text=_(
                "If no choice. It will not filter product by tag.")
        )
    
    def __init__(self, *args, **kwargs): 
        super(OscarLatestForm, self) .__init__(*args, **kwargs) 
        if hasTags:
            if self.instance.tag:
                self.fields['tag'].initial = self.instance.tag.split(",")

    def save(self, commit=True):
        obj = super(OscarLatestForm, self).save(commit=commit)

        if hasTags:
            tags = ",".join(self.cleaned_data.get('tag', []))
            obj.tag = tags
            obj.save()
            
        return obj

    class Meta:
        model = OscarLatest
        exclude = ['tag']

class OscarBestSellerForm(forms.ModelForm):
    if hasTags:
        tag = forms.MultipleChoiceField(
            choices=tagList,
            required=False,
            help_text=_(
                "If no choice. It will not filter product by tag.")
        )
    
    def __init__(self, *args, **kwargs): 
        super(OscarBestSellerForm, self) .__init__(*args, **kwargs) 
        if hasTags:
            if self.instance.tag:
                self.fields['tag'].initial = self.instance.tag.split(",")

    def save(self, commit=True):
        obj = super(OscarBestSellerForm, self).save(commit=commit)

        if hasTags:
            tags = ",".join(self.cleaned_data.get('tag', []))
            obj.tag = tags
            obj.save()
            
        return obj

    class Meta:
        model = OscarBestSeller
        exclude = ['tag']
