#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: cms_dumpdata.py 10152 2017-08-08 05:33:45Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-08-08 13:33:45 +0800 (Tue, 08 Aug 2017) $
# $Revision: 10152 $

import os
import sys
import json

from StringIO import StringIO

from django.core.management.base import BaseCommand
from django.core import serializers
from django.db.models import get_app, get_models
from django.db.models.query import QuerySet

class Command(BaseCommand):

    help = 'Dump all data include filer.File to initial_data.json'
    
    def handle(self, *args, **options):
        app = get_app('filer')
        
        modelList = get_models(app)
        
        dataStream = StringIO()
        
        def getObjects():
            for model in modelList:
                model.objects.queryset_class = QuerySet
                for obj in model.objects.iterator():
                    yield obj
                    
        
        serializers.serialize(
            'json', getObjects(), indent=2, 
            use_natural_keys=True, stream=dataStream)
                
        filerData = json.loads(dataStream.getvalue())
        
        os.system(
            "%s manage.py dumpdata auth > authData.json" %  
            sys.executable)
            
        os.system(
            ("%s manage.py dumpdata "
             "-e auth -e filer -e contenttypes > otherData.json") % 
             sys.executable)
        
        with open('authData.json') as f:
            content = f.read()
            authData = json.loads(content[content.index('['):])
        with open('otherData.json') as f:
            content = f.read()
            otherData = json.loads(content[content.index('['):])
        
        for ele in filerData:
            authData.append(ele)
        for ele in otherData:
            authData.append(ele)

        with open('initial_data.json', 'w') as f:
            content = f.write(json.dumps(authData))
        os.remove('authData.json')
        os.remove('otherData.json')
