#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: assign_templates.py 10628 2017-12-10 13:03:41Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-12-10 21:03:41 +0800 (週日, 10 十二月 2017) $
# $Revision: 10628 $

import os
import shutil
import random
import math

from django.core.management.base import BaseCommand
from django.template.loader import get_template
from django.template import Context

from Zephyrus.boilerplate.management.commands import createLogger

logger = createLogger(__name__, "AssignTemplates.log")

DIR_TEMPLATES_NUMBER = 100
CHOSE_NUMBER = 20

class Command(BaseCommand):

    help = 'Copy html to templates and copy static files to static.'
    
    def add_arguments(self, parser):
        parser.add_argument('start', type=str, help="start folder")
        parser.add_argument('dst', type=str, help="destination folder")
        parser.add_argument('--notCreateTxt', 
            type=bool, help="create sample txt", default=False)
        parser.add_argument('--templateNumber', 
            type=int, help="template number", default=DIR_TEMPLATES_NUMBER)
        parser.add_argument('--sampleNumber', 
            type=int, help="sample number", default=CHOSE_NUMBER)
        parser.add_argument(
            '-c', '--createBat', 
            action='store_true',
            help="Create Bat file use to test template.")

    def handle(self, *args, **options):
        startPath = options['start']
        dstPath = options['dst']
        
        notCreateTxt = options['notCreateTxt']
        templateNumber = options['templateNumber']
        sampleNumber = options['sampleNumber']
        
        for root, dirs, files in os.walk(startPath):
            if not root == startPath:
                break

            random.shuffle(dirs)
            
            for i, d in enumerate(dirs, 0):
                dirPath = os.path.join(startPath, d)
                dirName = str(math.ceil(float(i + 1) / templateNumber))
                dst = os.path.join(dstPath, dirName, d)
                shutil.copytree(dirPath, dst)

                if not notCreateTxt:
                    if (i + 1) % templateNumber == 0:
                        with open(
                            os.path.join(dstPath, dirName, "%s.txt" % dirName),
                             'w') as txt:
                            start = int(i - templateNumber + 1)
                            end = int(i + 1)
                            randomDir = dirs[start:end]
                            sample = random.sample(randomDir, sampleNumber)
                            txt.write('-----Sample Template-----\n')
                            txt.write('\n'.join(sample))
                            txt.write('\n-----All Template-----\n')
                            txt.writelines('\n'.join(randomDir))

                        if (options['createBat'] and 
                            sampleNumber == CHOSE_NUMBER):
                            temp = get_template('boilerplate/bat/AllTest.bat')
                            context1 = ({
                                'sampleDir': os.path.join(dstPath, dirName),
                                'sample': sample[0:10],
                            })
                            with open(os.path.join(dstPath, dirName, "AllTest1.bat"),'w') as bat1:
                                bat1.write(temp.render(context1))
                            context2 = ({
                                'sampleDir': os.path.join(dstPath, dirName),
                                'sample': sample[10:20],
                            })
                            with open(os.path.join(dstPath, dirName, "AllTest2.bat"),'w') as bat2:
                                bat2.write(temp.render(context2))



            
