#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: cms_loaddata.py 11055 2018-05-14 09:46:32Z Lavender $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-05-14 17:46:32 +0800 (週一, 14 五月 2018) $
# $Revision: 11055 $

import json

from django.core.management.base import BaseCommand
from django.core.management import call_command

from filer.models.imagemodels import Image

class Command(BaseCommand):
    
    help = 'Fixed filer image from dumpdata'

    def add_arguments(self, parser):
        parser.add_argument('data', type=str, help="data json")
    
    def handle(self, *args, **options):
        dataJson = options['data']
        call_command('loaddata', dataJson)  

        with open(dataJson) as data:
            allData = json.loads(data.read())

        imageData = \
            [d for d in allData if d['model'] == 'filer.image']

        for imgData in imageData:
            image = Image.objects.get(id=imgData['pk'])
            image.file_data_changed()
            


        
