#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: ContextProcessors.py 9195 2013-05-24 06:50:11Z Eric $
#
# Copyright (c) 2013 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Eric $
# $Date: 2013-05-24 06:50:11 +0000 (週五, 24 五月 2013) $
# $Revision: 9195 $

from django.conf import settings

from emencia.django.newsletter.context_processors import media as _media

from Theophrastus.TheophrastusSettings import MEDIA_URL

def media(request):
    """
    Adds media-related context variables to the context.
    """
    context = {
        'THEOPHRASTUS_MEDIA_URL': MEDIA_URL,
        'ENABLE_INTEGRATION': settings.ENABLE_INTEGRATION
    }
    _context = _media(request)
    context.update(_context)
    return context
