#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 9033 2013-04-03 07:09:10Z Yachu $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Yachu $
# $Date: 2013-04-03 15:09:10 +0800 (週三, 03 四月 2013) $
# $Revision: 9033 $

import types

from django.conf import settings

from Theophrastus.models import Newsletter

def replaceNewsletterKeyword(content):
    """
    Insert newsletter's site url to Facebook Feed plugin.

    @param content Newsletter's content.
    """
    s = ("http://{{ domain }}{% url 'newsletter_newsletter_contact' slug=newslett"
        "er.slug uidb36=uidb36 token=token %}")
    content = content.replace('ReplaceNewsletterSiteLink', s)

    appId = settings.FACEBOOK_FEED_APP_ID
    content = content.replace('ReplaceFacebookAppId', appId)

    s = ("http://{{ domain }}{% url 'Theophrastus.facebook.feed.complete' %}")
    content = content.replace('ReplaceRedirectUri', s)

    return content

def cleanFields(self, *args, **kwargs):
    if self.pk is None:
        self.content = replaceNewsletterKeyword(self.content)

Newsletter.clean = types.MethodType(cleanFields, None, Newsletter)

from emencia.django.newsletter.utils import newsletter

from Theophrastus.Utility import trackLinks

newsletter.track_links = trackLinks
