#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 8963 2013-03-25 08:56:48Z Eric $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Eric $
# $Date: 2013-03-25 08:56:48 +0000 (週一, 25 三月 2013) $
# $Revision: 8963 $

from django import forms
from django.contrib import admin
from django.utils.translation import ugettext as _

from emencia.django.newsletter.models import Newsletter
from emencia.django.newsletter.admin import NewsletterAdmin

from editor.TinyMCEWidget import CustomTinyMCEWidget

class NewsletterTinyMCEForm(forms.ModelForm):

    content = forms.CharField(
        widget=CustomTinyMCEWidget(attrs={'cols': 150, 'rows': 80}),
        label=_("Content"))

    def clean_header_reply(self):
        """
        Validate reply value.
        """
        reply = self.cleaned_data["header_reply"]
        try:
            reply.encode()
        except UnicodeEncodeError:
            raise forms.ValidationError(
                _("Incorrect value for reply, it can only include English "
                "word, number and symbol."))
        return reply

    class Meta:
        model = Newsletter
        fields = '__all__'

class NewsletterTinyMCEAdmin(NewsletterAdmin):

    list_display = ('title', 'mailing_list', 'server', 'status',
                    'formatedSendingDate', 'formatedCreationDate',
                    'formatedModificationDate',
                    'historic_link', 'statistics_link')

    def formatedSendingDate(self, obj):
        return obj.sending_date.strftime("%Y-%m-%d %H:%M:%S")
    formatedSendingDate.short_description = _('sending date')

    def formatedCreationDate(self, obj):
        return obj.creation_date.strftime("%Y-%m-%d %H:%M:%S")
    formatedCreationDate.short_description = _('creation date')

    def formatedModificationDate(self, obj):
        return obj.modification_date.strftime("%Y-%m-%d %H:%M:%S")
    formatedModificationDate.short_description = _('modification date')

    class Media:
        try:
            js = [
                'js/Newsletter.js',
            ]
        except AttributeError:
            pass

    form = NewsletterTinyMCEForm

admin.site.unregister(Newsletter)
admin.site.register(Newsletter, NewsletterTinyMCEAdmin)

from emencia.django.newsletter.models import Contact
from emencia.django.newsletter.admin import ContactAdmin

class ContactTheophrastusAdmin(ContactAdmin):
    list_display = (
        'email', 'first_name', 'last_name', 'tags', 'tester', 'subscriber',
        'valid', 'total_subscriptions', 'formatedCreationDate',
        'related_object_admin')

    def formatedCreationDate(self, obj):
        return obj.creation_date.strftime("%Y-%m-%d %H:%M:%S")
    formatedCreationDate.short_description = _('creation date')

admin.site.unregister(Contact)
admin.site.register(Contact, ContactTheophrastusAdmin)
