#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 8628 2013-01-10 03:35:33Z Yachu $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Yachu $
# $Date: 2013-01-10 11:35:33 +0800 (�g�|, 10 �@�� 2013) $
# $Revision: 8628 $

from django.contrib import admin
from django.conf import settings

if settings.DEBUG:
    from Theophrastus.models import ContactMailingStatus, Link

    admin.site.unregister(ContactMailingStatus)
    admin.site.unregister(Link)

from django_ses.models import SESStat
# Unregister.
admin.site.unregister(SESStat)

from tagging.models import Tag, TaggedItem
# Unregister.
admin.site.unregister(Tag)
admin.site.unregister(TaggedItem)

from django.db import models
from django.forms import Textarea

from emencia.django.newsletter.admin.mailinglist import MailingListAdmin

from Theophrastus.models import MailingList

admin.site.unregister(MailingList)

class NewMailingListAdmin(MailingListAdmin):
    formfield_overrides = {
        models.TextField: {'widget': Textarea(attrs={'rows': '', 'cols': ''})},
    }

admin.site.register(MailingList, NewMailingListAdmin)
