#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 9128 2013-05-09 12:21:11Z Yachu $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Yachu $
# $Date: 2013-05-09 20:21:11 +0800 (週四, 09 五月 2013) $
# $Revision: 9128 $

from django.db import models

from Iuppiter.Model import BaseModelMixin

from Theophrastus.models import Newsletter, Contact

class CloudMailInformation(models.Model, BaseModelMixin):
    """
    Mail sending information.
    """
    newsletter = models.ForeignKey(Newsletter, unique=False)

    contact = models.ForeignKey(Contact, unique=False)

    # Response id for sent mail.
    messageId = models.TextField(max_length=2048)
    # Response message for sent mail.
    message = models.TextField(default='')

class NewsletterInformation(models.Model, BaseModelMixin):

    newsletter = models.ForeignKey(Newsletter, unique=True)

    sync = models.BooleanField(default=True)

