#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 9048 2013-04-11 03:28:36Z Yachu $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Yachu $
# $Date: 2013-04-11 11:28:36 +0800 (週四, 11 四月 2013) $
# $Revision: 9048 $

from Iuppiter.Service import BaseService
from Iuppiter.Service import serviceGetter

from datetime import datetime

from Theophrastus.cloud import models

class CloudService(BaseService):
    """
    Offer several service for cloud.
    """

    def __init__(self, *args, **kws):
        """
        Constructor.
        """
        super(CloudService, self).__init__(models)

    def recordSendInformation(self, newsletter, contact, messageId, message=''):
        """
        Record information of send mail.

        @param newsletter Newsletter instance.
        @param contact Contact instance.
        @param messageId Request id for sent mail.
        @param message Request message for sent mail.
        """
        obj = self.getCloudMailInformation(
            newsletter=newsletter, contact=contact, messageId=messageId,
            errorOnNotFound=False)
        if obj:
            obj.message = message
            self.updateCloudMailInformation(obj)
        else:
            self.createCloudMailInformation(
                newsletter=newsletter, contact=contact,
                messageId=messageId, message=message)
