#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: urls.py 8822 2013-02-21 06:56:32Z Yachu $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Yachu $
# $Date: 2013-02-21 14:56:32 +0800 (週四, 21 二月 2013) $
# $Revision: 8822 $

from django.conf.urls import url, patterns

from Theophrastus.cloud import views

urlpatterns = patterns('',
    url(r'^bounces/$', views.getBounces,
        name='Theophrastus.cloud.getBounces'),
    url(r'^complains/$', views.getComplains,
        name='Theophrastus.cloud.getComplains'),

    url(r'^verify/$', views.verifyEmailAddress,
        name='Theophrastus.cloud.ajax.verifyEmailAddress'),
    url(r'^verify/delete/$', views.deleteVerifiedEmailAddress,
        name='Theophrastus.cloud.ajax.deleteVerifiedEmailAddress'),
    url(r'^verify/check/$', views.checkVerifiedEmailAddress,
        name='Theophrastus.cloud.ajax.checkVerifiedEmailAddress'),

    url(r'^notificationTopic/set/$', views.setNotificationTopic,
        name='Theophrastus.cloud.ajax.setNotificationTopic'),
)
