#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: TinyMCEWidget.py 9253 2013-07-02 04:04:07Z Yachu $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Yachu $
# $Date: 2013-01-30 12:13:45 +0800$
# $Revision: 9253 $

from django.utils.translation import ugettext as _
from django.core.urlresolvers import reverse
from django.conf import settings

from tinymce.widgets import TinyMCE

from TinyMCESettings import TEMPLATE_NAMES, STYLE_FORMATS

def getAllTemplates(originTemplates):
    """
    Seeker HTML files in 'tinymceTemplate' folder.

    @return [{
                'title': _("Invitation card"),
                'src': "/newsletters/templates/invitationcard/",
                'description': _("Invitation card template.")
            }, {
                'title': _("Greeting card"),
                'src': "/newsletters/templates/greetingcard/",
                'description': _("Greeting card template.")
           }]
    """
    names = [i['name'] for i in originTemplates]
    templates = []

    for info in TEMPLATE_NAMES:
        name = info.get('name', '')
        if name in names:
            continue
        if name:
            info.update({
                'src': '/newsletters/plus/editor/templates/%s/' % name.title()
            })
            templates.append(info)

    for info in originTemplates:
        name = info.get('name', '')
        info.update({
            'src': '/newsletters/plus/editor/templates/%s/' % name.title()
        })

    return templates

class CustomTinyMCEWidget(TinyMCE):
    """
    Reference: http://code.google.com/p/django-tinymce/issues/detail?id=58
    """
    def __init__(self, contentLanguage=None, attrs=None, mceAttrs={}):
        # Here we add some configuration on the fly as you can see our button
        # is called minimizeButton
        minBtn = 'minimizeButton,'
        settings.TINYMCE_DEFAULT_CONFIG['theme_advanced_buttons4'] += minBtn

        moreBtn = 'moreButton,'
        settings.TINYMCE_DEFAULT_CONFIG['theme_advanced_buttons1'] += moreBtn

        # Then here I add a callback function for that setup named
        # 'addButtonCallback'.
        # I realized that tinyMCE calls the function even when passed as a
        # string, the problems was when passing an anonymous function as a
        # string since it wasn't rendered as javascript so wasn't called.
        settings.TINYMCE_DEFAULT_CONFIG['setup'] = 'addButtonCallback'

        # Attach templates.
#        link = settings.TINYMCE_DEFAULT_CONFIG['template_external_list_url']
#        from django.core.urlresolvers import reverse
#        link = reverse(link)
#        settings.TINYMCE_DEFAULT_CONFIG['template_external_list_url'] = link

        templates = settings.TINYMCE_DEFAULT_CONFIG.get(
            'template_templates', [])
        templates.extend(getAllTemplates(templates))
        settings.TINYMCE_DEFAULT_CONFIG['template_templates'] = templates

        # Append TinyMCE config.
        styleFormats = settings.TINYMCE_DEFAULT_CONFIG.get(
            'style_formats', None)
        if styleFormats:
            # Merge.
            styleFormats.extend(STYLE_FORMATS)
        else:
            # Assign.
            styleFormats = STYLE_FORMATS
        settings.TINYMCE_DEFAULT_CONFIG['style_formats'] = styleFormats

        super(CustomTinyMCEWidget, self).__init__(contentLanguage,
                                                  attrs, mceAttrs)

    class Media:
        try:
            # Here we add our custom javascript which contains the
            # minimizeButton setup callback function.
            js = [
                'js/Customization.js',
            ]
        except AttributeError:
            pass
