#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 9110 2013-04-30 08:34:43Z Yachu $
#
# Copyright (c) 2013 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Yachu $
# $Date: 2013-04-30 16:34:43 +0800 (週二, 30 四月 2013) $
# $Revision: 9110 $

from django.conf.urls import url, patterns

from Theophrastus.integration import views

urlpatterns = patterns('',
    url(r'^statistics/display/(?P<groupId>\d+)/$',
        views.displayStatistics,
        name='Theophrastus.integration.views.displayStatistics'),
    url(r'^charts/totalRate/(?P<groupId>\d+)/$', views.getTotalRateData,
        name='Theophrastus.integration.ajax.getTotalRateData'),
    url(r'^charts/total/(?P<groupId>\d+)/$', views.getTotalData,
        name='Theophrastus.integration.ajax.getTotalData'),

    url(r'^subscribers/display/(?P<groupId>\d+)/$',
        views.displaySubscribers,
        name='Theophrastus.integration.views.displaySubscribers'),
    url(r'^subscribers/charts/history/(?P<groupId>\d+)/$',
        views.getHistory,
        name='Theophrastus.integration.ajax.getHistory'),

    url(r'^admin/groupMappingTable/groups/$',
        views.getGroups,
        name='Theophrastus.admin.integration.views.getGroups'),
)

