#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 8755 2013-01-30 04:13:45Z Yachu $
#
# Copyright (c) 2013 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Yachu $
# $Date: 2013-01-30 12:13:45 +0800$
# $Revision: 8755 $

from django import forms
from django.utils.translation import gettext as _

from Theophrastus.editor.TinyMCEWidget import CustomTinyMCEWidget
from Theophrastus.newsletter_extension.models import Header, Footer

class HeaderTinyMCEForm(forms.ModelForm):
    """
    Form for header.
    """
    content = forms.CharField(
        widget=CustomTinyMCEWidget(attrs={'cols': 80, 'rows': 80}),
        label=_("Content"),
        required=False)

    class Meta:
        model = Header
        fields = '__all__'

class FooterTinyMCEForm(forms.ModelForm):
    """
    Form for footer.
    """
    content = forms.CharField(
        widget=CustomTinyMCEWidget(attrs={'cols': 80, 'rows': 80}),
        label=_("Content"),
        required=False)

    class Meta:
        model = Footer
        fields = '__all__'
