/**
$Id: AdjustHeight.js 8068 2012-09-03 08:44:13Z Yachu $

Copyright (c) 2013 Nuwa Information Co., Ltd, All Rights Reserved.

Licensed under the Proprietary License, 
you may not use this file except in compliance with the License.
You may obtain a copy of the License at our web site.

See the License for the specific language governing permissions and
limitations under the License.

$Author: Yachu $
$Date: 2012-09-03 16:44:13 +0800 (週一, 03 九月 2012) $
$Revision: 8068 $
*/

/**
 * Adjust target's height.
 *
 * @param {Object} settings Adjust settings, ex:
 *        settings = {
 *            header
 *            footer
 *            target
 *        } // DOM element, height(number), class name(.classname) or id.
 */
Iuppiter.Util.AdjustTargetHeight = {
    getObjectByClassName: function(name) {
        if (Iuppiter.browser.isIE8) {
            var els = document.querySelectorAll('.' + name);
            var el = els.length > 0 ? els[0] : undefined;
            return el;
        }
        else {
            var els = document.getElementsByClassName(name);
            var el = els.length > 0 ? els[0] : undefined;
            return el;
        }
    },
    
    getObjectById: function(id) {
        return document.getElementById(id);
    },
    
    getHeight: function(arg) {
        var getHeigthWithObject = function(obj) {
            var height;
            if (obj.offsetHeight) {
                height = obj.offsetHeight;
            }
            if (obj.clientHeight) {
                Math.min(height, obj.clientHeight);
            }
            return height;
        }
        if (typeof(arg) == 'object') {
            return getHeigthWithObject(arg);
        }
        else if (typeof(arg) == 'string') {
            if (arg.substr(0, 1) == '.') {
                var name = arg.substr(1);
                var el = this.getObjectByClassName(name);
                return getHeigthWithObject(el);
            }
            else {
                return getHeigthWithObject(document.getElementById(arg));
            }
        }
        else if (typeof(arg) == 'number') {
            return arg;
        }
        else {
            return 0;
        }
    },
    
    getAvailHeight: function() {
        //var isQuirksMode = document.compatMode === 'CSS1Compat' ? false : true;
        var height;
        if (document.documentElement) {
            height = document.documentElement.clientHeight;
        }
        if (document.body) {
            height = Math.max(height, document.body.clientHeight)
        }
        return height
    },
    
    adjust: function(settings) {
        var target;
        if (typeof(settings.target) == 'string') {
            var s = settings.target;
            if (s.substr(0, 1) == '.') {
                target = this.getObjectByClassName(s.substr(1));
            }
            else {
                target = this.getObjectById(settings.target);
            }
        }
        else {
            target = settings.target;
        }

        var headerHeight = this.getHeight(settings.header);
        var footerHeight = this.getHeight(settings.footer);

        var availHeight = this.getAvailHeight(); //Math.min(screen.height, screen.availHeight);
        var bestHeight = availHeight - (headerHeight + footerHeight);

        target.style.height = bestHeight + 'px';
    }
    
};
