#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 8755 2013-01-30 04:13:45Z Yachu $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Yachu $
# $Date: 2013-01-30 12:13:45 +0800 (週三, 30 一月 2013) $
# $Revision: 8755 $

from django.utils.translation import ugettext as _

from emencia.django.newsletter import models as emModels

import types

from django.db import models

@models.permalink
def getStatisticsUrl(self):
    return ('Theophrastus.views.displayStatistics', (self.slug,))

@models.permalink
def getSubscriberUrl(self):
    return ('Theophrastus.views.displaySubscribers', (self.slug,))

emModels.Newsletter.getStatisticsUrl = types.MethodType(
    getStatisticsUrl, None, emModels.Newsletter)

emModels.Newsletter.getSubscriberUrl = types.MethodType(
    getSubscriberUrl, None, emModels.Newsletter)

def getUnicode(self):
    if self.id == 1:
        return _("Cloud SMTP Server")
    return '%s (%s)' % (self.name, self.host)

emModels.SMTPServer.__unicode__ = types.MethodType(
    getUnicode, None, emModels.SMTPServer)
