#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: cms_loaddata.py 12526 2020-09-24 10:42:30Z Casey $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Casey $
# $Date: 2020-09-24 19:42:30 +0900 (週四, 24 九月 2020) $
# $Revision: 12526 $

import json

from django.core.management.base import BaseCommand
from django.core.management import call_command
from django.contrib.auth.models import Permission
from django.contrib.contenttypes.models import ContentType
from filer.models.imagemodels import Image

class Command(BaseCommand):

    help = 'Fixed filer image from dumpdata'

    def add_arguments(self, parser):
        parser.add_argument('data', type=str, help="data json")
        parser.add_argument(
            '-pc', '--permissionAndContenttypes',
            action='store_true',
            help="Load auth(permission) and contenttypes data.")

    def handle(self, *args, **options):
        if options['permissionAndContenttypes']:
            Permission.objects.all().delete()
            ContentType.objects.all().delete()

        dataJson = options['data']
        call_command('loaddata', dataJson)

        with open(dataJson, encoding="utf-8") as data:
            allData = json.loads(data.read())

        imageData = \
            [d for d in allData if d['model'] == 'filer.image']

        # file_data_changed 出錯不會有訊息
        for imgData in imageData:
            image = Image.objects.get(id=imgData['pk'])
            image.file_data_changed()




